/* Table 4(1) */
cd "D:\Research\China Trade\Reimport and carry trade\Review of Finance\"
use "reimports-hs8-kg-for Tables 2 and 4.dta", clear 
xtset hs8 year
log using "results_log.log", replace
gen m2gr_diff_lvw=m2gr_yoy_diff*lvw
gen m2gr_diff_lvw_soe=m2gr_yoy_diff*lvw*soesh
gen crlvw=dcr_annual*lvw
gen crlvwsoe=dcr_annual*lvw*soesh
gen tsllvw=tsl*lvw
tab year, gen(yd)
global endolist crlvw crlvwsoe
global ivlist m2gr_diff_lvw m2gr_diff_lvw_soe 
global exoglist lvw tsl tsllvw tariffVAT soesh prcsh3 wbash3
xtivreg2 lreimp ($endolist=$ivlist) $exoglist yd*, first fe i(hs8)

/* Table 4(2) */
cd "D:\Research\China Trade\Reimport and carry trade\Review of Finance\"
use "reimports-hs8-kg-for Tables 2 and 4.dta", clear  
xtset hs8 year
gen highval=1 if vw!=.
replace highval=0 if vw<6.41458 /* 50 percentile of V/W in the sample used in the for regressions on Tables 2 and 4 */
gen cr_highval=dcr_annual*highval
gen tsl_highval=tsl*highval
gen cr_highval_soesh=cr_highval*soesh
gen m2gr_diff_highval=m2gr_yoy_diff*highval
gen m2gr_diff_highval_soesh=m2gr_yoy_diff*highval*soesh
tab y, gen(yd)
global endolist cr_highval cr_highval_soesh
global ivlist m2gr_diff_highval m2gr_diff_highval_soesh
global exoglist highval tsl tsl_highval tariffVAT soesh prcsh3 wbash3
xtivreg2 lreimp ($endolist=$ivlist) $exoglist yd*, first fe i(hs8)
